import sys

# načtení požadavku z příkazové řádky
n = int(sys.argv[1])

# vyhledání příslušné sekvence
pořadí = 0
with open('fasta.fa', mode='tr', encoding='utf-8') as soubor:
    while True:     # nekonečná smyčka
        #                    hlavička         sekvence
        try:
            hlavička, sekvence = next(soubor), next(soubor)
        except StopIteration:
            # jsme na konci souboru => ukončíme nekonečnou smyčku
            break
        # odstraníme konce řádek, ať se nám tam nemotají
        hlavička, sekvence = hlavička.rstrip(), sekvence.rstrip()
        # máme načtenou další sekvenci
        pořadí += 1
        # čekáme na požadovanou sekvenci
        if pořadí == n:
            print(f'{hlavička} length={len(sekvence)} pos={pořadí}')
            print(sekvence)
            # našli jsme požadovanou sekvenci, není třeba hledat dál
            break
