from time import time
from functools import cache

@cache
def fib(n):
    if n<= 1:
        return n
    else:
        return fib(n-1) + fib(n-2)

for i in range(30, 40):
    print(f'{i}:')
    t_start = time()
    print(f'\t{fib(i)}')
    print(f'\t{time() - t_start}')

'''
30:
        832040
        0.0
31:
        1346269
        0.0
32:
        2178309
        0.0
33:
        3524578
        0.0
34:
        5702887
        0.0
35:
        9227465
        0.0
36:
        14930352
        0.0
37:
        24157817
        0.0
38:
        39088169
        0.0
39:
        63245986
        0.0010077953338623047
'''
